$(document).ready(function($){
    
    // media query event handler
    if (matchMedia) {
        
        const mq992 = window.matchMedia("(min-width: 992px)");
        mq992.addListener(WidthChange);
        WidthChange(mq992);

    }

    function navigationClosed(){
        $('body').removeClass('noscroll');
        $('#navigation').removeClass('active');
    }
    
    
    // media query change 992px
    function WidthChange(mq992) {
        
        
        if (mq992.matches) {
            // window width is at least 992px
            console.log('matches 992px');
            
            // Navigation - display
            $('.main-container__left').removeAttr('style');
            // Close if navigation is open on mobile version
            navigationClosed();


        } else {
            // window width is less than 992px

            // Navigation - hide
            $('.main-container__left').css('display', 'none');

        }
    
    }

    // Navigation submenu open on click
    if ($('.navigation-list__item').hasClass('active')) {
        $('.navigation-list__item.active').children('.navigation-sublist').slideDown(300);
    }
    $('.navigation-list__item').on('click', '.navigation-list__link', function(){
        $(this).siblings('.navigation-sublist').slideToggle(300);
    });

    // Navigation mobile
    $('.nav-hamburger').on('click', function(){

        // check if is active
        if ($('#navigation').hasClass('active')) {
            return;
        } else {
            $('body').addClass('noscroll');
            $('.main-container__left').show(300);
            $('#navigation').addClass('active');
        }

    });
    $('.navigation-close').on('click', function(){

        // check if is active
        if ($('#navigation').hasClass('active')) {
            $('.main-container__left').hide(300);
            navigationClosed();
        } else {
            return;
        }

    });

    // Popup - show on click
    var $popup_menu_trigger = $('.popup-menu-trigger');
    var $popup_menu = $('.popup-menu');

    $popup_menu_trigger.on('click', function(event){
        // if( $popup_menu_trigger.siblings('.popup-menu').is(':visible') ) {
        //     $popup_menu_trigger.siblings('.popup-menu').slideUp(200);
        // }
        event.stopPropagation();
        $(this).siblings('.popup-menu').slideToggle(300);
    });
    $popup_menu.on('click', function(event){
        event.stopPropagation();
    });

    // CUSTOM - Select Dropdown on click

    // Slidedown dropdown select
    $('.c-select__s-item').on('click', function(event){
        event.stopPropagation();
        $this = $(this);
        $(this).siblings('.c-select__menu').slideToggle(300, function(){

            // When finish toggle check if menu is opened or not and add or remove class
            if ( $this.siblings('.c-select__menu').attr('style').indexOf('none') != -1 ) {
                // console.log('nema');
                $this.parent('.c-select').removeClass('c-select_open');
            } else {
                // console.log('ima');
                $this.parent('.c-select').addClass('c-select_open');
            }

        });

    });
    // On item select
    $('.c-select__item').on('click', function(event){
        $this = $(this);
        // If is disabled click return
        if($(this).hasClass('c-select_disabled-item')) {
            return;
        }

        // If is select-actions menu
        if($(this).parent().hasClass('select-actions__menu')) {
            $(this).parent('.c-select__menu').slideUp(200, function(){

                // When finish toggle check if menu is opened or not and add or remove class
                if ( $this.parent('.c-select__menu').attr('style').indexOf('none') != -1 ) {
                    console.log('nema');
                    $this.closest('.c-select').removeClass('c-select_open');
                } else {
                    console.log('ima');
                    $this.closest('.c-select').addClass('c-select_open');
                }
            });
            return;
        }

        event.stopPropagation();

        // remove selected class from siblings if exist and add to selected item
        $(this).siblings().removeClass('selected');
        $(this).addClass('selected');
        
        // Get selected item data-value
        var $dataAttr = $(this).attr('data-value');

        // Get selected item text
        var $dataText = $(this).text();

        // Add selected item text to default select
        $(this).parent().siblings('.c-select__s-item').find('.c-select_text-default').text($dataText);

        // Add selected item data-value to hidden input
        $(this).parent().siblings('input[name="widget"]').val($dataAttr);
        
        // Slide up select
        $(this).parent('.c-select__menu').slideUp(200);

    });
    $('.c-select__menu').on('click', function(event){
        event.stopPropagation();
    });

    // On body click if is popup or select open close them
    $('html, body').on('click', function(){
        $('.c-select__menu').slideUp(200);
        $popup_menu.slideUp(200);
    });

    /* TABS NAVIGATION */
    $('.tabs-nav').on('click', '.tabs-nav__link', function(event){
        event.preventDefault();


        
        if( $(this).parent().hasClass('tabs-nav__item') ) {

            $(this).parent().siblings('.tabs-nav__item').each(function(){
                $(this).children('.tabs-nav__link').removeClass('active');
            });
        } else {
            $('.tabs-nav__link').each(function(){
                $(this).removeClass('active');
            });
        }
        $(this).addClass('active');

        var $dataNav = $(this).attr('data-tabs-nav');
        $('.tabs-nav-section:not(.'+ $dataNav +')').hide(200, function(){
            $('.'+ $dataNav +'').show(300);
        });

        // If is Matching change header content
        console.log($dataNav);
        if( $dataNav == 'c-matching') {
            showMatchingHeader();
        } else {
            showStandardHeader();
        }

    });

    function showMatchingHeader() {
        $('.d-widget__header').css('margin-bottom', '10px');
        $('.header-standard').hide();
        $('.header-matching').addClass('active');
        $('.rightbar-standard').hide();
        $('.rightbar-matching').addClass('active');
    }
    
    function showStandardHeader() {
        $('.d-widget__header').removeAttr('style');
        $('.header-standard').show();
        $('.header-matching').removeClass('active');
        $('.rightbar-standard').show();
        $('.rightbar-matching').removeClass('active');
        $('.rightbar-matching-2').hide();
        $('.c-matching__buttons-send').show();
    }

    // It's a Match
    $('.c-matching__buttons-send').on('click', function(){
        $this = $(this);
        $('.rightbar-matching').removeClass('active');
        $('.rightbar-matching-2').show(300, function(){
            $this.hide();
        });
    });

    // On input file upload changed
    $('.input-file__input').on('change', function() {
        if($(this)[0].files.length != 0) {

            $filename = $(this)[0].files[0].name;
            $(this).siblings('.input-file__content').addClass('attached');
            $(this).siblings('.input-file__content').find('.input-file__text').text($filename);
        } else {
            $(this).siblings('.input-file__content').removeClass('attached');
        }
    });


});