$(document).ready(function($){

    // Variables
    var $popup_menu = $('.popup-menu');

    function onDashDivChangeWidth(){
        // Check if section with class rectangle with is smaller because of choosen layout, and add him mobile class
        if($('.cl-1__rectangle').width() < 400 ) {
            $('.cl-1__rectangle').addClass('cl-1_rectangle-mobile');
        } else {
            $('.cl-1__rectangle').removeClass('cl-1_rectangle-mobile');
            // remove inline styles on dash-rect
            $('.dash-rect__section').removeAttr('style');
        }
    }


    // media query event handler
    if (matchMedia) {
        
        const mq992 = window.matchMedia("(min-width: 992px)");
        mq992.addListener(WidthChange);
        WidthChange(mq992);

    }
    
    
    // media query change 992px
    function WidthChange(mq992) {
        
        
        if (mq992.matches) {
            // window width is at least 992px
            console.log('matches 992px');


            $('.dash-mobile-head__link:not(:first)').removeClass('active').blur();
            $('.dash-mobile-head__link:first').addClass('active')

            // remove inline styles on dash-rect
            $('.dash-rect__section').removeAttr('style');

            onDashDivChangeWidth();


        } else {
            // window width is less than 992px

        }
    
    }

    /* DASHBOARD EMPTY STATE */
    // Add class selected on dashboard layout select
    if($('.choose-layout').length){ 
        $('.choose-layout__item').on('click', function(){
            $(this).siblings().removeClass('selected');
            $(this).addClass('selected');
        });
    }


    /* DASHBOARD */
    // Dashboard links on click
    $('.dash-mobile-head__link').on('click', function(event){
        event.preventDefault();
        $(this).siblings().removeClass('active');
        $(this).addClass('active');
        var $dataLink = $(this).attr('data-dash-link');
        $('.cl-1__rectangle').find('.dash-rect__section:not(.'+ $dataLink +')').hide(300, function(){
            $('.'+ $dataLink).show(300);
        });
    });

    // Change Layout on Dashboard page
    $('.popup-menu_c-layout').on('click', '.popup-menu__item', function(){
        $this = $(this);
            
        var dashC = document.getElementsByClassName('main-content')[0].classList;
        var layClass;
        dashC.forEach(function(element) {
            if(element.indexOf('layout-') != -1) {
                layClass = element;
            }
        });
        var $this_data = $this.attr('data-c-layout');
        $this.siblings('.popup-menu__item').removeClass('selected');
        $this.addClass('selected');
        $('.main-content').removeClass(layClass);
        $('.main-content').addClass($this_data);
        $popup_menu.slideUp(200);

        
        onDashDivChangeWidth();

    });




    // On window resize adapt dashboard widget style 
    $(window).resize(function(){
        onDashDivChangeWidth();
    })

    // On Dashboard show It's a match modal after 3s
    function showMatch() {
        $('body').addClass('noscroll');
        $('.match').show(300, function(){
            $(this).css({
                'display': 'flex',
                'justify-content' : 'center',
                'align-items' : 'center'
            })
        });
    }
    
    // var timerId = setInterval(() => showMatch(), 3000);

    // setTimeout(() => { clearInterval(timerId); console.log('stop'); }, 5000);

    $('.its-match__close, .its-match__button').on('click', function(){
        $('body').removeClass('noscroll');
        $('.match').hide(300);
    });





})