/*** Chart JS ***/
// REVNUE 2018

if ( document.getElementById('revnue2018') != null ) {

    var revCtx = document.getElementById('revnue2018').getContext('2d');
    // create gradient
    var grd = revCtx.createLinearGradient(100.000, 0.000, 100.000, 270.000);
    // Add colors
    grd.addColorStop(0.000, 'rgba(60, 52, 251, 1.000)');
    grd.addColorStop(1.000, 'rgba(255, 255, 255, 0.000)');


    var myChart1 = new Chart(revCtx, {
        type: 'line',
        data: {
            labels: ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '10'],
            datasets: [{
                pointBackgroundColor: '#ffffff',
                lineTension: 0,
                data: [4, 6, 5, 8, 7, 10, 7, 10, 12, 13, 15],
                backgroundColor: grd,
                borderColor: '#3C34FB',
                borderWidth: 1
            }]
        },
        options: {
            maintainAspectRatio: false,
            // onResize: updateCharts,
            scales: {
                yAxes: [{
                    gridLines: {
                        drawBorder: false,
                        display: false
                    },
                    ticks: {
                        display: false,
                        beginAtZero:true
                    }
                }],
                xAxes: [{
                    gridLines: {
                        drawBorder: false,
                        // display: false
                    },
                    ticks: {
                        display: false
                    }
                }]
            },
            legend: {
                display: false
            }
        }
    });

}

// GOAL REVNUE 2018
if ( document.getElementById('goal-revnue2018') != null ) {

    var goalRevCtx = document.getElementById('goal-revnue2018').getContext('2d');

    var myChart2 = new Chart(goalRevCtx, {
        type: 'doughnut',
        data: {
            labels: ['Expenses', 'Income'],
            datasets: [{
                data: [18, 35, 47],
                backgroundColor: ['#FB3477', '#782BFF'],
                borderColor: [
                    '#D8D8D8'
                ],
                borderWidth: 1,
            }]
        },
        options: {
            cutoutPercentage: 90,
            rotation: 90,
            maintainAspectRatio: false,
            // onResize: updateCharts,
            scales: {
                yAxes: [{
                    gridLines: {
                        drawBorder: false,
                        display: false
                    },
                    ticks: {
                        display: false
                    }
                }],
                xAxes: [{
                    gridLines: {
                        drawBorder: false,
                        display: false
                    },
                    ticks: {
                        display: false
                    }
                }]
            },
            legend: {
                position: 'bottom',
                reverse: true,
                labels: {
                    usePointStyle: true,
                    fontColor: '#7B7E87',
                    fontFamily: 'MS300',
                    fontSize: 14,
                    padding: 20,
                }
            }
        }
    });

}


// GOAL SALES 2018

if ( document.getElementById('goal-sales2018') != null ) {

    var goalRevCtx = document.getElementById('goal-sales2018').getContext('2d');

    var myChart2 = new Chart(goalRevCtx, {
        type: 'doughnut',
        data: {
            labels: ['Products sold'],
            datasets: [{
                data: [18, 35],
                backgroundColor: ['#FB9B34'],
                borderColor: [
                    '#D8D8D8'
                ],
                borderWidth: 1,
            }]
        },
        options: {
            cutoutPercentage: 90,
            // rotation: 90,
            maintainAspectRatio: false,
            // onResize: updateCharts,
            scales: {
                yAxes: [{
                    gridLines: {
                        drawBorder: false,
                        display: false
                    },
                    ticks: {
                        display: false
                    }
                }],
                xAxes: [{
                    gridLines: {
                        drawBorder: false,
                        display: false
                    },
                    ticks: {
                        display: false
                    }
                }]
            },
            legend: {
                position: 'bottom',
                reverse: true,
                labels: {
                    usePointStyle: true,
                    fontColor: '#7B7E87',
                    fontFamily: 'MS300',
                    fontSize: 14,
                    padding: 20,
                }
            }
        }
    });

}

// SALES

if ( document.getElementById('sales') != null ) {

    var salesCtx = document.getElementById('sales').getContext('2d');
    // create gradient
    var salesRose = salesCtx.createLinearGradient(100.000, 0.000, 100.000, 275.000);
    var salesBlue = salesCtx.createLinearGradient(100.000, 0.000, 100.000, 275.000);
    var salesPurple = salesCtx.createLinearGradient(100.000, 0.000, 100.000, 275.000);
    // Add colors

    // Add colors
    salesRose.addColorStop(0.700, 'rgba(255, 37, 174, 1.000)');
    salesRose.addColorStop(1.000, 'rgba(255, 255, 255, 0.000)');
    salesBlue.addColorStop(0.400, 'rgba(60, 52, 251, 1.000)');
    salesBlue.addColorStop(1.000, 'rgba(255, 255, 255, 0.000)');
    salesPurple.addColorStop(0.400, 'rgba(166, 37, 255, 1.000)');
    salesPurple.addColorStop(1.000, 'rgba(255, 255, 255, 0.000)');


    var myChart3 = new Chart(salesCtx, {
        type: 'bar',
        data: {
            labels: ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24', '25', '26', '27'],
            datasets: [
                {
                    pointBackgroundColor: '#ffffff',
                    data: [35, 55, 75, 45, 49, 40, 36, 57, 77, 47, 67, 49, 25, 47, 77, 49, 30, 20, 40, 60, 70, 58, 65, 42, 37, 45, 80],
                    backgroundColor: [salesPurple, salesBlue, salesBlue, salesPurple, salesPurple, salesPurple, salesPurple, salesBlue, salesBlue, salesBlue, salesBlue, salesPurple, salesRose, salesBlue, salesBlue, salesPurple, salesRose, salesRose, salesPurple, salesBlue, salesBlue, salesBlue, salesBlue, salesPurple, salesRose, salesBlue, salesPurple],
                    borderWidth: 0,
                    stack: 1
                },
                {
                    label: 'Maximum',
                    backgroundColor: 'rgba(216, 216, 216, 0.2)',
                    data: [95, 95, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100],
                    borderWidth: 0,
                    stack: 1
                }
            ]
        },
        options: {
            cornerRadius: 20,
            maintainAspectRatio: false,
            responsiveAnimationDuration: 0,
            // onResize: updateCharts,
            scales: {
                yAxes: [{
                    gridLines: {
                        drawBorder: false,
                        display: false,
                    },
                    ticks: {
                        display: false,
                        max: 100
                    },
                    stacked: true
                }],
                xAxes: [{
                    barThickness: 4,
                    gridLines: {
                        drawBorder: false,
                        display: false
                    },
                    ticks: {
                        display: false
                    },
                    stacked: true
                }]
            },
            legend: {
                display: false
            }
        }
    });

}

// function updateCharts() {
//     console.log(myChart1.update);
//     myChart1.resize();
//     myChart1.canvas.parentNode.style.maxWidth = '99%';
// }